/*********** Generated on 2025/12/28 19:52:23 by reswrap version 6.0.0 *********/

#include "help.h"

/* Created by reswrap from file help.txt */
const char help[]=
  "\n"
  "\n"
  "                                                   A . d . i . e\n"
  "\n"
  "                                         The ADvanced Interactive Editor\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "Introduction.\n"
  "\n"
  "Adie is an extremely fast and convenient programming text editor and file viewer"
  " written using the FOX Toolkit, and supports UTF8 unicode text rendering.\n"
  "\n"
  "Flexible syntax coloring is available for multiple programming languages and may"
  " include user-written extensions.  Each syntactical element may be given its own"
  ", user-defined color, or other character attributes.\n"
  "\n"
  "Project browsing is made easy by displaying a File- and Directory-browser side b"
  "y side with the text buffer so files may be visited by means of a single click. "
  " Files may also be opened simply by highlighting a file name, compiler warning m"
  "essage, or #include directive and hitting a single button; Adie will search for "
  "the file in the same directory as an already loaded file, or in a number of pred"
  "efined directories (like for example include directories).\n"
  "\n"
  "Unlimited undo and redo capability will allow changes to be unwound painlessly, "
  "making accidental deletes easy to recover.\n"
  "\n"
  "Bookmarks may be set to quickly hop around in the text; a special \"insertion po"
  "int\" bookmark is automatically set whenever text is modified, allowing the user"
  " to alway jump back to the last modified line.\n"
  "\n"
  "General Features.\n"
  "\n"
  "  - User-extensible syntax coloring for multiple programming languages.\n"
  "  - Block selection and manipulation.\n"
  "  - Highlighting of current line.\n"
  "  - Optional line number display.\n"
  "  - Preferences are configurable with convenient dialogs.\n"
  "  - Ability to edit huge text sizes.\n"
  "  - Wheel mouse scroll support, with vernier (fine) scrolling support.\n"
  "  - Right-mouse pixel-proportional scrolling.\n"
  "  - Help window (this text) which can stay up during editing.\n"
  "  - Parse vim, emacs, and adie modelines to set programming language.\n"
  "  - Edit multiple files in multi-window mode.\n"
  "  - Automatically configure hardtabs when loading files recognized as Makefiles."
  "\n"
  "  - Searching files matching a wildcard pattern for a regular expression.\n"
  "  - Built-in calculator for expressions.\n"
  "  - Optionally persist bookmarks when closing file.\n"
  "  - Optionally persist scroll-position when closing file.\n"
  "\n"
  "File Access Features.\n"
  "\n"
  "  - File Dialog supporting bookmarked directories.\n"
  "  - Drag and drop file into editor to switch to file.\n"
  "  - File- and directory-browser allows single-click file loading.\n"
  "  - Visit recently edited files from recent files menu.\n"
  "  - Parse filename and line number to open file at given line (and column) from "
  "command line.\n"
  "  - Jump to file and line number of highlighted compiler warnings or errors.\n"
  "  - Open new window or switch current window to another file.\n"
  "  - Open highlighted #include-files by searching common include directories (con"
  "figurable).\n"
  "  - Detect external programs changing or removing file being edited outside of t"
  "he editor.\n"
  "  - Insert text from another file into the text editor.\n"
  "  - Extract text from the text editor to another file.\n"
  "  - Save As, and Save-To to save text to another filename.\n"
  "  - Reload file from disk to revert to on-disk version.\n"
  "  - Customize wild-card patterns for limiting files shown in File Dialog or File"
  " Browser.\n"
  "  - Search files wildcard pattern for text matching regular expression, and open"
  " with a click.\n"
  "\n"
  "Editing Features.\n"
  "\n"
  "  - Drag select, word select, or whole lines selection.\n"
  "  - Block selection, cut-and paste text blocks, insert or overstrike text blocks"
  ".\n"
  "  - Cut and paste to clipboard support.\n"
  "  - X11 primary selection support using middle-mouse paste.\n"
  "  - Unlimited undo/redo capability with alternate history mode.\n"
  "  - Drag-and-drop support for text move or copy.\n"
  "  - Highlight matching braces or parentheses.\n"
  "  - Set bookmarks to remember points of interest in the file.\n"
  "  - Search and Replace dialog for simple, or regular expression search, with pre"
  "vious search history.\n"
  "  - Quick incremental search bar supporting search-as-you type.\n"
  "  - Highlight numerical expression and calculate its result.\n"
  "  - Filter selected text through shell-commands.\n"
  "  - Simple auto-indent feature.\n"
  "  - Indent or unindent selected lines of text.\n"
  "  - Search for highlighted text.\n"
  "  - Set a fixed word wrap column, or perform fluent word wrap mode.\n"
  "  - Strip trailing spaces, strip carriage-returns for DOS files.\n"
  "  - Add carriage-returns when saving to DOS files.\n"
  "  - Mouse wheel scrolling.\n"
  "  - Right-mouse drag to scroll proportionally.\n"
  "  - Right-mouse context menu with handy options.\n"
  "\n"
  "Syntax Coloring Features.\n"
  "\n"
  "  - Describe syntax of programming language using collection of nested regular e"
  "xpressions.\n"
  "  - Custom coloring for each syntax rule.\n"
  "  - Switch collection of coloring rules based on file-extension, or based on mod"
  "e line.\n"
  "  - Selected files may be custom colorized based on entire file name.\n"
  "  - Explicitly set syntax from pulldown menu.\n"
  "  - Syntax description also configures some switches (e.g. enable tab support fo"
  "r Makefiles).\n"
  "  - Group syntaxes of similar programming languages to give them similar colors."
  "\n"
  "\n"
  "\n"
  "Starting a New Document.\n"
  "\n"
  "To start a new document, invoke the 'File' / 'New' menu, or press the 'New' butt"
  "on on the toolbar.  A new window will be opened, with a filename like 'untitled'"
  " or 'untitled1', etc. in the current directory.  The editor will remember the do"
  "cument hasn't been given a filename yet, and will prompt for a filename when bei"
  "ng saved.\n"
  "\n"
  "A second method to start a new document is the 'New File' menu, or 'New File' bu"
  "tton on the toolbar.  This will immediately prompt the user for a filename using"
  " the File Dialog. However, the file will not be created on disk until its saved."
  "  The advantage of this method is that the file extension will be known, and thu"
  "s the correct syntax can be chosen for highlighting the newly added text. Of cou"
  "rse since the filename is known, there will be no need for a prompt later to ent"
  "er it.\n"
  "\n"
  "\n"
  "Opening and Saving Files the Old Fashioned Way.\n"
  "\n"
  "To open a file, you can invoke the 'File' / 'Open' menu, or press on the 'Open' "
  "button on the toolbar.  This will bring up the standard File Dialog, which allow"
  "s you to select a file.\n"
  "To save a file, you can either invoke the 'File' / 'Save', 'Save As', or 'Save T"
  "o' menu option.  'Save' will save the text to the same filename as it was loaded"
  " from.  'Save As' will prompt the user to enter a new filename, then save the fi"
  "le to the new name.  This will leave the document under the new name in the text"
  " buffer, and a subsequent 'Save' will save the document to the new filename.\n"
  "When you invoke 'Save To', you will be prompted for a new filename, similar to '"
  "Save As', except that the document will not change to the new filename.  A subse"
  "quent 'Save' will still save the document to its prior name.\n"
  "\n"
  "\n"
  "The File Dialog.\n"
  "\n"
  "When working with the File Dialog, you can quickly navigate to the desired file "
  "by typing the first few letters of a filename and then pressing Enter (Return).\n"
  "If you don't know what you're looking for, you can navigate among the files usin"
  "g the arrow-keys.  Use Backspace key to move to a higher directory folder.  Use "
  "Control-H to move to your home directory, or Control-W to move back to the curre"
  "nt working directory.\n"
  "If any bookmarks have been set, you can quickly jump to previously bookmarked di"
  "rectory folders.\n"
  "Of course, you can also directly type the path of the file into the 'File Name' "
  "text entry box.\n"
  "To limit visual overload, use 'File Filter' to select a wild-card pattern to lim"
  "it the displayed files to those matching the pattern.\n"
  "Once the proper file name has been selected, press Return to select it.  Alterna"
  "tively, when selecting files with the mouse, you can simply double-click the fil"
  "e and immediately return.\n"
  "The File Dialog is designed to facilitate the experienced user, and allows selec"
  "tion of a file without ever using the mouse.  Because your hands are already on "
  "the keyboard.\n"
  "\n"
  "To bring up the File Dialog via keyboard, use Control-O (open existing file), Sh"
  "ift-Control-N (new file with name), Shift-Control-S (save as), or Shift-Control-"
  "T (save to).\n"
  "\n"
  "\n"
  "Opening Files Using the File and Directory Browser.\n"
  "\n"
  "An alternative method to open files is the File and Directory Browser. You can d"
  "isplay the File and Directory Browser by invoking the 'File Browser' option unde"
  "r the 'View' menu.  To open a file using the File and Directory Browser, simply "
  "click on the file. If there are many files, you may want to limit the number of "
  "files displayed by specifying a file wild-card pattern in the 'Filter' combo box"
  ".\n"
  "The patterns can be any file wildcard expression such as '*.cpp'.  By default, t"
  "he File and Directory Browser shows all files, i.e. the pattern is '*'.\n"
  "Additional patterns can be added to the list using the 'Preferences' Dialog.\n"
  "\n"
  "\n"
  "Opening Recently Visited Files.\n"
  "\n"
  "The recent file section of the 'File' menu shows files which have been recently "
  "visited.  You can quickly get back to a file you've been editing simply by selec"
  "ting one of these recent files.\n"
  "If you select a file which is already open, the window currently editing that fi"
  "le will be brought to the top.\n"
  "\n"
  "\n"
  "Opening Files by Drag and Drop.\n"
  "\n"
  "Using a file browser such as PathFinder or other Konqueror or other XDND compati"
  "ble file browsers, you can simply drop a file into the text pane and have the ed"
  "itor open this file.  If the current file being edited has been changed, you wil"
  "l be prompted to save it first before switching to the dropped file.\n"
  "\n"
  "\n"
  "Opening a Selected Filename.\n"
  "\n"
  "Selecting any filename, possibly in another application, and invoking the 'File'"
  " / 'Open Selected' menu, or the 'Open Selected' toolbar button causes the editor"
  " to open the selected file.  If more than the filename alone is selected, the ad"
  "ditional text may be subject to various interpretations.  When the selected file"
  "name is of the form:\n"
  "\n"
  "   #include \"filname.h\"\n"
  "\n"
  "or:\n"
  "\n"
  "   #include <filename.h>\n"
  "\n"
  "The editor will search for this file in the same directory as the currently load"
  "ed file, and if not found there, look into a sequence of (possibly relative) sea"
  "rch paths. [You can specify the list of search paths to search by entering a lis"
  "t of absolute or relative pathnames into the 'Preferences' dialog, under the 'Mi"
  "scellaneous' sub panel]. When the selected filename is of the form:\n"
  "\n"
  "   filename.cpp:177\n"
  "\n"
  "or:\n"
  "\n"
  "   filename.cpp:177:9\n"
  "\n"
  "or:\n"
  "\n"
  "  filename.cpp(177)\n"
  "\n"
  "or:\n"
  "\n"
  "  filename.cpp, line 177\n"
  "\n"
  "or:\n"
  "\n"
  "  File = filename.cpp, Line = 177\n"
  "\n"
  "or:\n"
  "\n"
  "  filename.cpp:\n"
  "\n"
  "The editor will not only load the filename, but also jump to the given line numb"
  "er (and column number, if available).  In the case column number is available, i"
  "t will also place the cursor on the 9-column of line 177.  If this file has alre"
  "ady been loaded, the editor will simply jump to the given line number in the alr"
  "eady open file, and bring the window to the front.\n"
  "This option is very useful when fixing compiler errors.  Various other popular c"
  "ompiler error or warning formats are supported besides GCC.\n"
  "If a file is of the form:\n"
  "\n"
  "  \"C:\\\\Users\\\\Annual Sales Figures.txt\"\n"
  "\n"
  "Which represents an escaped pathname [possibly, because there are spaces in the "
  "filename], the editor will un-escape the selected pathname, and try to open it. "
  " On Linux and other unix-like systems, it will assume bash-escape rules; on Wind"
  "ows, as this example here is, it will follow Windows command-line escape rules.\n"
  "\n"
  "\n"
  "Editing Text.\n"
  "\n"
  "When a new document is first created, the editor will initially be placed into '"
  "Insert Mode,' i.e. any characters you type will be inserted at the current curso"
  "r location.  Hitting the 'INS' key, the editor will be placed in overstrike-mode"
  ".  In overstrike mode, characters you type will replace the ones already there ["
  "unless you are at the end of a line].\n"
  "\n"
  "Tabs Or Spaces?\n"
  "\n"
  "When you hit the 'Tab' key, a special tab-character will be inserted ('Tab Mode'"
  "), unless the editor is in ('EMT', or 'Emulated Tabs Mode'). The tab character i"
  "s typically set to 8 columns, but this may be changed if desired.  If you very, "
  "very rarely need to insert a tab-character, but mostly want to use 'EMT' mode, y"
  "ou can insert a hard-tab via Control-Tab key.\n"
  "\n"
  "\n"
  "Navigating Through The Text.\n"
  "\n"
  "The usual methods apply: Arrow keys, Delete, Backspace, Page-Up, Page Down, Home"
  ", End, etc.  A few keys have interesting modifiers. Holding the 'Shift' key whil"
  "e pressing navigation keys causes the range of characters to be selected.  Holdi"
  "ng the 'Alt' key similarly causes a 'Block-Select' to be performed.  With some n"
  "avigation keys, holding 'Control' will cause words, not characters, to become se"
  "lected.  For the 'Control-Up' and 'Control-Down' the text buffer will scroll whi"
  "le keeping cursor on the same line.\n"
  "\n"
  "\n"
  "Mouse Operations.\n"
  "\n"
  "The left mouse button is used to place the cursor at some location in the text. "
  " If you hold the left mouse button while dragging the mouse, a range of text is "
  "selected, starting from the initial location where the left-button was first pre"
  "ssed (the anchor point), to the location where the mouse is moved next.  Releasi"
  "ng the left button will cause the region of text to remain selected.\n"
  "\n"
  "Often, you will want to select whole words, or lines.  This is also performed wi"
  "th the left mouse button: to select whole words, double-click and hold the left "
  "mouse button, then drag while holding it down. The selection now will try to enc"
  "ompass whole words.  Simply double-clicking will select the whole word at the lo"
  "cation where the click takes place.\n"
  "\n"
  "To select lines, triple-click and hold the left mouse button. As you drag while "
  "holding the left button, whole lines will be selected if the pointer moves from "
  "line to line.  Simply triple-clicking will select the entire line containg the l"
  "ocation where the click takes place.\n"
  "\n"
  "Block-selection is performed by holding the Control key while pressing the left "
  "mouse button. When the block-selection is zero columns wide, there is no selecte"
  "d text, but a multi-line insert position.\n"
  "A paste operation where multi-line insert position is in effect will insert line"
  "s of text in the middle of the selected columns.\n"
  "For block-selections to work, the editor must NOT be in line wrap mode, and the "
  "font used to display text must be fixed pitch or \"cell\" based font.  Block sel"
  "ections will not work with proportional fonts or line-wrapping.\n"
  "\n"
  "Clicking right mouse button normally brings up the context popup menu.  Pressing"
  " the right mouse button and then dragging will move the text proportionally to t"
  "he mouse movement.  This is very convenient for sideways scrolling or fine-posit"
  "ioning the text around where the action is.\n"
  "\n"
  "The middle mouse button (or wheel-button) is used to paste text selected anywher"
  "e on the screen (on Linux); however, pressing and holding the middle mouse butto"
  "n on a selected text will drag the selection to a new location, and drop it wher"
  "e the middle button is released [except if the middle button is release while th"
  "e insertion cursor is inside the selection being dragged.\n"
  "\n"
  "The mouse wheel usually scrolls the text up and down.  The amount of scrolling c"
  "an be configured, but it defaults to 10 lines.  Pressing Control while rolling t"
  "he mouse wheel causes the scrolling to advance by one page of text at a time (th"
  "e seven league boots, if you will).  Use it to roll through large text files qui"
  "ckly.\n"
  "\n"
  "\n"
  "Scrolling Text.\n"
  "\n"
  "Use the scrollbars to scroll text. You can press the scrollbar thumb with the le"
  "ft mouse button, then move it.  Doing so while holding Control or Shift key will"
  " set the scrollbar into \"fine\" scrolling mode, moving the text very delibratel"
  "y and proportionally to the mouse movement.  Using the middle mouse button anywh"
  "ere in the scrollbar will cause the scroll position to jump to the new location."
  "  Holding the middle mouse button subsequently will scroll as normal.  You can u"
  "se this technique if you know approximately where in the text you want to go.\n"
  "\n"
  "When dragging a selection, or performing a drag- and drop-operation, the text bu"
  "ffer will also scroll automatically when the cursor gets near the edge of the wi"
  "ndow.\n"
  "\n"
  "\n"
  "The Clipboard.\n"
  "\n"
  "After selecting some text, you can cut (Control-X) or copy (Control-C) this text"
  " to the clipboard. A subsequent paste operation will then insert the contents of"
  " the clipboard at the current cursor location.\n"
  "If some text has been selected in another application, then you can paste this t"
  "ext by placing the cursor at the right spot in your text and invoking the Paste "
  "command (or type Control-V).\n"
  "\n"
  "If a block-selection is in effect, the lines of text on the clipboard will repla"
  "ce the selected block of text; columns of text before and after the selection wi"
  "ll remain intact, but columns past the last selected column may move left of rig"
  "ht, depending on whether the new text is wider or smaller than the original bloc"
  "k.\n"
  "If the new text comprises more lines of text than the original selected block, n"
  "ew blank lines will be appended and the spill-over will be inserted at the selec"
  "ted column.\n"
  "\n"
  "\n"
  "The Primary Selection.\n"
  "\n"
  "When text is selected anywhere (possibly in another application), the editor can"
  " paste this text into the current edit-buffer by means of the middle mouse butto"
  "n [or by pressing the wheel-button if you have a wheel mouse].\n"
  "\n"
  "\n"
  "Text Drag and Drop.\n"
  "\n"
  "After selecting some text, you can drag this text to another location by pressin"
  "g the middle mouse button; because Adie is fully drag and drop enabled, you can "
  "not only drag a selection from one place to another inside the edit-buffer, but "
  "also between different editor applications, or even from Adie to another drag an"
  "d drop enabled application or vice-versa.\n"
  "Within the same text window, the drag defaults to a text-movement.  You can chan"
  "ge this to a text copy by holding down the Control key while you're dragging.\n"
  "Between one text window and another, the drag defaults to a copy operation you c"
  "an change this to a text movement by holding down the Shift key while dragging.\n"
  "\n"
  "\n"
  "Undo and Redo.\n"
  "\n"
  "The editor supports unlimited (well, the limit is large...) undo and redo capabi"
  "lity.  Each time you insert, remove, or replace some text, the editor remembers "
  "what you did.\n"
  "If you make a mistake, you can undo the last edit, and the one before that, and "
  "so on. Having invoked undo many times, it is sometimes desirable to invoke the r"
  "edo command, i.e. to perform the original editing operation again.  Thus, you ca"
  "n move backward or forward in time.\n"
  "\n"
  "The \"Merge Undos\" option consolidates contiguous single-character insertions o"
  "r deletions into larger undo commands.  When the \"Merge Undos\" mode is on, an "
  "undo or redo will undo inserts or deletes on a word-by-word basis.  It tries to "
  "be smart about which character classes are \"mergeable,\" so that for example ed"
  "iting source code, we're not backing over operators and other punctuation that m"
  "ay have special meanings in programming languages (we're still experimenting wit"
  "h this feature so the precise behaviour will be fine-tuned a bit in the future.\n"
  "\n"
  "A new addition to the undo system is the \"Alternate History\" mode.  If, after "
  "undoing several commands, you decide edit the buffer in a different way, all com"
  "mands that you have undone would normally be deleted, and you would no longer be"
  " able to go forward with redo from that point.\n"
  "However, when \"Alternate History\" mode on, Adie will remember \"the path not t"
  "aken\" and allow you to undo back to the original text, prior to the change.\n"
  "\n"
  "Needless to say, this may vastly expand the amount of memory used by the undo sy"
  "stem; however, to prevent things getting out of hand the undo list is periodical"
  "ly trimmed to keep it manageable.\n"
  "\n"
  "When you load a file, or save a file after editing it, the undo system will reme"
  "mber the state of the text buffer as \"clean\" or \"marked\".  Making further ch"
  "anges, you will be able to quickly go back to this clean state using the \"Rever"
  "t\" command.  Unlike reload, no disk I/O is performed when this happens: we're s"
  "imply exucuting undo or redo commands to go back to the marked state.\n"
  "\n"
  "Of course, if a huge amount of text was modified, and the undo list had to be tr"
  "immed, you will potentially not be able to reach the marked state anymore if it "
  "wanders into the trimmed range.  However, the default limits are set pretty larg"
  "e for editing regular source files; if you ever run into these limits, they can "
  "be changed in the preferences panel.\n"
  "\n"
  "\n"
  "Evaluating Numerical Expressions.\n"
  "\n"
  "Often, when writing technical software, you want to pre-calculate some numbers. "
  " Adie makes this easy by allowing you to simply type a formula, highlighting it,"
  " and then invoking the Edit / Expression menu, or hitting the Expression button "
  "on the toolbar.\n"
  "\n"
  "For instance:\n"
  "\n"
  "  circumference=PI*2*10;\n"
  "\n"
  "Selecting the part PI*2*10 and executing the Expression button will replace the "
  "text with:\n"
  "\n"
  "  circumference=62.8318530717959;\n"
  "\n"
  "The expression calculator knows the usual operators:\n"
  "\n"
  "  ? :\talternate expression\n"
  "  <, <=, >, >=\tcomparisons\n"
  "  ==, !=\tequalities\n"
  "  <<, >>\tbit-shifts\n"
  "  &, |, ^\tbit-wise operations\n"
  "  +, -\taddition and subtraction\n"
  "  *, /, %\tmultiply, divide, modulo\n"
  "  **\tpower\n"
  "  -, ~\tunary minus, bitwise not\n"
  "  ( )\tparenthesized subexpressions\n"
  "\n"
  "The expression calculator knows common math functions: abs(), acos(), acosh(), a"
  "sin(), asinh(), atan(), atan2(), atanh(), cbrt(), ceil(), cos(), cosh(), cub(), "
  "erf(), erfc(), exp(), exp2(), exp10(), floor(), inverf(), inverfc(), isfin(), is"
  "inf(), isnan(), log(), log2(), log10(), max(), min(), near(), pow(), round(), si"
  "n(), sinh(), sqr(), sqrt(), tan(), tanh(), trunc(), wrap(), wrap4().\n"
  "\n"
  "And a few mathematical constants: PI, E, DTOR (degree to radians), RTOD (radians"
  " to degrees).\n"
  "\n"
  "\n"
  "Modeline Support.\n"
  "\n"
  "Modelines are hints embedded in a comment that suggest certain editor settings. "
  " For instance, in a document with no file-extension, a modeline can be used to s"
  "uggest which syntax coloring language mode to select.\n"
  "If modelines are enabled, Adie tries to detect the presence of a modeline somewh"
  "ere in the first 30 lines, or in the last 10 lines of a document.\n"
  "\n"
  "Modelines can automatically enable or disable some features in the editor, such "
  "as syntax coloring language mode, tan stop settings, text wrapping mode, tab emu"
  "lation or hard-tab mode, and auto-indent modes.\n"
  "\n"
  "Vim modelines are of the form:\n"
  "\n"
  "\t\"[text]{white}{vi:|vim:|ex:}[white]{options1}\"\n"
  "\n"
  "In Vim modelines, programming language, wrap mode, wrap columns, auto-indent, ta"
  "b-columns, and soft- or hard-tab modes may be configured.  These take precedence"
  " over the defaults and values in the syntax file if present.\n"
  "\n"
  "Emacs modelines are of the form:\n"
  "\n"
  "\t\"-*- key1: value1; key2: value2; -*-\"\n"
  "\n"
  "In Emacs modelines, programming language, tab stops, wrap mode, soft- or hard-ta"
  "b modes, and auto-indent may be configured. Example:\n"
  "\n"
  "\t-*- mode: C++; tab-width: 8; -*-\n"
  "\n"
  "Finally, in Adie modelines, which are of the form:\n"
  "\n"
  "\t\"adie: key1=value1 key2=value2 key3=value3 :\"\n"
  "\n"
  "Language mode, tab stops, wrap columns, wrap mode, soft- or hard-tab mode, and a"
  "uto-indent may be configured.  The variables are simple two-letter names.  The v"
  "ariable \"la\" configures the programming language to be used for syntax colorin"
  "g; the variable \"ts\" sets the tab-stop value. The variable \"ww\" controls wra"
  "p column, and \"wr\" enables word-wrapping if set to 1.  The variable \"et\" con"
  "trols hard-tabs 0 or soft-tabs 1, and the variable \"ai\" enables auto-indent if"
  " set to 1.\n"
  "For example, the adie mode line:\n"
  "\n"
  "\tadie: la=C++ ts=8 ww=80 wr=1 et=1 ai=1:\n"
  "\n"
  "This would set the syntax coloring to C++-mode, 8-column tabs, wrap lines at 80 "
  "columns, expand tabs to spaces, and turn auto-indent on.\n"
  "\n"
  "These settings may also be set in the syntax file; however, the modeline, if ena"
  "bled, will override the value in the syntax file or the default setting from the"
  " dialog, if present.\n"
  "\n"
  "\n"
  "Searching Files.\n"
  "\n"
  "The Search Files dialog can be used to search files for a particular search stri"
  "ng or regular expression pattern.  You typically don't want to search all types "
  "of files, but only text files or source files.\n"
  "Thus, just like the File Dialog, you can apply a wildcard filter to limit the fi"
  "les to be examined.  Moreover, you can select which directory folder to search. "
  " For a larger project, you optionally can also search subdirectories of that dir"
  "ectory folder.\n"
  "Once the search parameters have been set, click Search to start the search.  Dep"
  "ending on the number of files to be searched, this may sometimes take some time,"
  " so periodically, the editor check to see if the Pause button has been pressed. "
  " After pausing the search, you can either resume, or stop.\n"
  "As the files are being searched, file locations and context of successful search"
  "es (hits) are recorded.\n"
  "You can click on these to open the file and jump to the location of the hit.\n"
  "\n"
  "Multiple searches may be performed, and the string to be searched does not have "
  "to be the same each time a search is started.  Pressing Delete button will howev"
  "er delete all the results and present you with a clean slate.\n"
  "\n"
  "\n"
  "Search and Replace.\n"
  "\n"
  "Adie uses the standard Search Dialog for searching strings. The search dialog of"
  "fers forward and backward searches (relative to the current cursor location), an"
  "d three search modes:\n"
  "\n"
  "Exact. In the Exact mode, a search looks for a verbatim occurrence of the search"
  " string in the text.\n"
  "\n"
  "Ignore Case. In the Ignore Case mode, a search looks for a verbatim occurrence a"
  "lso, but while disregarding the uppercase/lowercase distinctions.\n"
  "\n"
  "Expression. In the Expression mode, the the search performs a full regular expre"
  "ssion match.  The regular expression syntax being used is very similar to PERL a"
  "nd is as follows:\n"
  "\n"
  "\n"
  "  Special Constructs:\n"
  "\n"
  "  ( ... )\tGrouping sub pattern\n"
  "  (?i ... )\tMatch sub pattern case insensitive\n"
  "  (?I ... )\tMatch sub pattern case sensitive\n"
  "  (?n ... )\tMatch sub pattern with newlines\n"
  "  (?N ... )\tMatch sub pattern with no newlines\n"
  "  (?: ... )\tNon-capturing parentheses\n"
  "  (?= ... )\tZero width positive lookahead\n"
  "  (?! ... )\tZero width negative lookahead\n"
  "  (?<= X )\tZero width positive (arbitrary) lookbehind\n"
  "  (?<! X )\tZero width negative (arbitrary) lookbehind\n"
  "  (?> X )\tAtomic grouping (possessive match)\n"
  "\n"
  "\n"
  "  Greedy quantifiers:\n"
  "\n"
  "  *\tMatch 0 or more [greedy]\n"
  "  +\tMatch 1 or more [greedy]\n"
  "  ?\tMatch 0 or 1 [greedy]\n"
  "  {}\tMatch 0 or more [greedy]\n"
  "  {n}\tMatch n times [greedy]\n"
  "  {,m}\tMatch no more than m times [greedy]\n"
  "  {n,}\tMatch n or more [greedy]\n"
  "  {n,m}\tMatch at least n but no more than m times [greedy]\n"
  "\n"
  "\n"
  "  Lazy quantifiers:\n"
  "\n"
  "  *?\tMatch 0 or more [lazy]\n"
  "  +?\tMatch 1 or more [lazy]\n"
  "  ??\tMatch 0 or 1 [lazy]\n"
  "  {}?\tMatch 0 or more times [lazy]\n"
  "  {n}?\tMatch n times [lazy]\n"
  "  {,m}?\tMatch no more than m times [lazy]\n"
  "  {n,}?\tMatch n or more [lazy]\n"
  "  {n,m}?\tMatch at least n but no more than m times [lazy]\n"
  "\n"
  "\n"
  "  Possessive quantifiers:\n"
  "\n"
  "  *+\tMatch 0 or more [possessive]\n"
  "  ++\tMatch 1 or more [possessive]\n"
  "  ?+\tMatch 0 or 1 [possessive]\n"
  "  {}+\tMatch 0 or more times [possessive]\n"
  "  {n}+\tMatch n times [possessive]\n"
  "  {,m}+\tMatch no more than m times [possessive]\n"
  "  {n,}+\tMatch n or more [possessive]\n"
  "  {n,m}+\tMatch at least n but no more than m times [possessive]\n"
  "\n"
  "\n"
  "  Boundaries:\n"
  "\n"
  "  ^\tMatch begin of line\n"
  "  $\tMatch end of line\n"
  "  \\<\tBegin of word\n"
  "  \\>\tEnd of word\n"
  "  \\b\tWord boundary\n"
  "  \\B\tWord interior\n"
  "  \\A\tMatch only beginning of string\n"
  "  \\Z\tMatch only and end of string\n"
  "\n"
  "\n"
  "  Character classes:\n"
  "\n"
  "  [abc]\tMatch 'a', 'b', or 'c'\n"
  "  [^abc]\tMatch any but 'a', 'b', or 'c'\n"
  "  [a-zA-Z]\tMatch upper- or lower-case a through z\n"
  "  []]\tMatches ']'\n"
  "  [-]\tMatches '-'\n"
  "\n"
  "\n"
  "  Predefined character classes:\n"
  "\n"
  "  .\tMatch any character\n"
  "  |\tAlternation\n"
  "  []\tCharacter class\n"
  "  \\d\tDigit [0-9]\n"
  "  \\D\tNon-digit\n"
  "  \\s\tSpace\n"
  "  \\S\tNon-space\n"
  "  \\w\tWord character [a-zA-Z_0-9]\n"
  "  \\W\tNon-word character\n"
  "  \\l\tLetter [a-zA-Z]\n"
  "  \\L\tNon-letter\n"
  "  \\h\tHex digit [0-9a-fA-F]\n"
  "  \\H\tNon-hex digit\n"
  "  \\u\tSingle uppercase character\n"
  "  \\U\tSingle lowercase character\n"
  "  \\p\tPunctuation (not including '_')\n"
  "  \\P\tNon punctuation\n"
  "\n"
  "\n"
  "  Back References:\n"
  "\n"
  "  \\1\tReference to 1st capturing group\n"
  "  \\2\tReference to 2nd capturing group\n"
  "  ..\n"
  "  \\9\tReference to 9th capturing group\n"
  "\n"
  "\n"
  "  Characters:\n"
  "\n"
  "  x\tAny character\n"
  "  \\\\\tBackslash character '\\'\n"
  "  \\cX\tControl character (X is '@', 'A'...'Z', '[', '\\', ']', '^', '_', or '?'"
  " for DEL)\n"
  "  \\xFF\tHexadecimal number (should be exactly two hex-digits)\n"
  "  \\033\tOctal (not to exceed 255 in value)\n"
  "  \\a\tAlarm, bell\n"
  "  \\b\tOnly in character classes: a Backspace character code. Otherwise, word-bo"
  "undary\n"
  "  \\e\tEscape character\n"
  "  \\t\tTab\n"
  "  \\f\tForm feed\n"
  "  \\n\tNewline\n"
  "  \\r\tReturn\n"
  "  \\v\tVertical tab\n"
  "  \\X\tJust X (unless X is one of [dDsSwWlLhHuUpP\\0123456789xcaetfnrv])\n"
  "\n"
  "\n"
  "Greedy match (the default) tries to match as many characters as possible, but ba"
  "cks off one at a time until a match is found.  Lazy match tries to match as few "
  "characters as possible, but advances one at a time until a match is found.  The "
  "possessive match behaves much like the greedy match, but does not back off; if t"
  "he rest of the pattern does not succeed, the match fails.\n"
  "Possessive match can often be a major guard against unnecessary recursion by cal"
  "ling it quits early, in cases where backing off has no possibility of success.\n"
  "\n"
  "\n"
  "Keyboard Bindings.\n"
  "\n"
  "The following table lists the keyboard bindings.\n"
  "\n"
  "Key:\tAction:\n"
  "====\t=======\n"
  "\n"
  "  Up\tMove cursor up.\n"
  "  Shift+Up\tMove cursor up and extend selection.\n"
  "  Ctl+Up\tScroll text downward, keeping current line.\n"
  "  Down\tMove cursor down.\n"
  "  Shift+Down\tMove cursor down and extend selection.\n"
  "  Ctl+Down\tScroll text upward, keeping current line.\n"
  "  Left\tMove cursor left.\n"
  "  Shift+Left\tMove cursor left and extend selection.\n"
  "  Ctl+Left\tMove cursor left by one word.\n"
  "  Ctl+Shift+Left\tMove cursor left by one word and extend selection.\n"
  "  Right\tMove cursor right.\n"
  "  Shift+Right\tMove cursor right and extend selection.\n"
  "  Ctl+Right\tMove cursor right by one word.\n"
  "  Ctl+Shift+Right\tMove cursor right by one word and extend selection.\n"
  "  Home\tMove cursor to begin of line.\n"
  "  Shift+Home\tMove cursor to begin of line and extend selection.\n"
  "  Ctl+Home\tMove cursor to top of text.\n"
  "  Ctl+Shift+Home\tMove cursor to to top of text and extend selection.\n"
  "  End\tMove cursor to end of line.\n"
  "  Ctl+End\tMove cursor to bottom of text.\n"
  "  Shift+End\tMove cursor to end of line and extend selection.\n"
  "  Ctl+Shift+End\tMove cursor to bottom of text and extend selection.\n"
  "  Page Up\tMove cursor up one page.\n"
  "  Shift+Page Up\tMove cursor up one page and extend selection.\n"
  "  Page Down\tMove cursor down one page.\n"
  "  Shift+Page Down\tMove cursor down one page and extend selection.\n"
  "  Insert\tToggle between insert mode and overstrike mode.\n"
  "  Shift+Insert\tPaste text from clipboard.\n"
  "  Ctl+Insert\tCopy selected text to clipboard.\n"
  "  Delete\tDelete character after cursor, or text selection.\n"
  "  Ctl+Delete\tDelete word after cursor.\n"
  "  Shift+Delete\tDelete to end of line.\n"
  "  BackSpace\tDelete character before cursor, or text selection.\n"
  "  Ctl+BackSpace\tDelete word before cursor.\n"
  "  Shift+BackSpace\tDelete to begin of line.\n"
  "  Return\tInsert end of line, add indent if auto-indent is on.\n"
  "  Shift+Return\tInsert end of line, and indent even if auto-indent is off.\n"
  "  Ctl+Return\tInsert end of line only.\n"
  "  Tab\tInsert (emulated) tab.\n"
  "  Ctl-Tab\tInsert hard tab.\n"
  "  Ctl+Shift+<\tMove current line up.\n"
  "  Ctl+Shift+>\tMove current line down.\n"
  "  Ctl-D\tCopy current line.\n"
  "  Ctl+A\tSelect all text.\n"
  "  Ctl+K\tDelete current line.\n"
  "  Ctl+X\tCut selected text to clipboard.\n"
  "  Ctl+C\tCopy selected text to clipboard.\n"
  "  Ctl+V\tPaste text from clipboard.\n"
  "\n"
  "\n"
  "Changing Font.\n"
  "\n"
  "You can change font by invoking the Font Selection Dialog from the Font menu. Th"
  "e Font Dialog displays four list boxes showing the font Family, Weight, Style, a"
  "nd Size of each font.\n"
  "You can narrow down the number of fonts displayed by selecting a specific charac"
  "ter set, setwidth, pitch, and whether or not scalable fonts are to be listed onl"
  "y.\n"
  "The All Fonts checkbutton causes all fonts to be listed. Use this feature if you"
  " need to select old-style X11 bitmap fonts.\n"
  "The Preview window shows a sample of text in the selected font.\n"
  "\n"
  "\n"
  "Changing Preferences.\n"
  "\n"
  "Since there is no accounting for tastes, Adie can be extensively configured by m"
  "eans of the Preferences dialog. The Preferences dialog is comprised of a number "
  "of subpanes which allow you to change colors, editor modes, file patterns, and w"
  "ord delimiters.\n"
  "\n"
  "\n"
  "Changing Colors.\n"
  "\n"
  "The colors subpane allows you to change the colors used in the File/Directory br"
  "owser, and the Text Window.\n"
  "You can simply drag colors from one color well to another, or you can double-cli"
  "ck on a color well and bring up the Color Dialog.\n"
  "The Color Dialog offers a number of ways to create a new color, either by select"
  "ing one of the pre-defined color wells, by mixing a custom color in RGB, HSV, or"
  " CMYK color space, or by selecting a named color from a list.\n"
  "\n"
  "\n"
  "Changing Editor Settings.\n"
  "\n"
  "The editor subpane is used to change various modes of the editor:\n"
  "\n"
  "Word Wrapping.  This enables word wrapping mode for the Text Window; when word w"
  "rapping is turned on, text flowed to stay within the wrap margins.\n"
  "\n"
  "Fixed Wrap Margin.  When this feature is enabled, the text is flowed to stay wit"
  "hin a fixed wrap column; when disabled, the Text Window is in continuous wrappin"
  "g mode, and the text is flowed to fit the size of the Text Window.  This option "
  "has no effect if the Word Wrapping option is off.\n"
  "\n"
  "Wrap Margin.  This specifies the column at which paragraphs are to be wrapped; t"
  "he wrap margin only has effect if the fixed wrap margin option is selected.\n"
  "\n"
  "Tab Columns.  This specifies the tab spacing, in terms of spaces.\n"
  "\n"
  "Strip Carriage Returns.  When this option is selected, MS-Windows/MS-DOS text fi"
  "les with lines ending in CRLF are transformed into LF only files upon read; this"
  " is mostly of interest when loading DOS files on a UNIX system; when Adie runs u"
  "nder MS-Windows, files are normally automatically translated back and forth.\n"
  "\n"
  "Strip Trailing Spaces.  When selected, Adie will remove all white-space after th"
  "e last printable character when reading a file.\n"
  "\n"
  "Auto Indent.  This causes spaces or tabs to be inserted to match the previous li"
  "ne; this option is meant for programmers.\n"
  "\n"
  "Brace Match Time.  When entering a brace, parenthesis, or bracket, the cursor te"
  "mporarily jumps to the matching brace and pauses there for a bit before hopping "
  "back to the insert position.  If the brace match time is set to 0, then this fea"
  "ture is disabled.\n"
  "\n"
  "Insert Tab Characters.  When this option is selected, hard tab characters are in"
  "serted when entering the tab key.  If the option is not selected then entering t"
  "he tab key will insert the corresponding number of spaces into the text buffer.\n"
  "\n"
  "Mouse Wheel Lines.  This is the number of lines scrolled when the mouse wheel is"
  " rotated by one notch.  When holding the control key while using the wheel, the "
  "text scrolls by one page at a time; when holding the alt key, it scrolls one pix"
  "el at a time.\n"
  "\n"
  "Save View of File.  When this option is selected, the current view or scroll pos"
  "ition is saved so that a subsequent visit to this file can immediately jump back"
  " to the same view.\n"
  "Disabling this option will cause all remembered views to be forgotten.\n"
  "\n"
  "Save Bookmarks.  When selected, all currently set bookmarks will be saved for th"
  "is file; a subsequent visit to this file will restore the bookmarks.\n"
  "Disabling this option will cause all remembered bookmarks to be forgotten.\n"
  "\n"
  "\n"
  "Changing File Patterns.\n"
  "\n"
  "This subpane allows you to enter a list of file patterns, one pattern on each li"
  "ne. These patterns are used in the File/Directory browser and the File Dialog.  "
  "They are especially useful in the File/Directory browser as it allows you to cau"
  "se the File/Directory browser to only show those file types you want to see (e.g"
  ". only source files).\n"
  "Each line of a pattern has the format:\n"
  "\n"
  "   patternname (patternlist)\n"
  "\n"
  "Where patternname is the name of the pattern (e.g. \"C Source\") and the pattern"
  "list is a comma separated list of patterns (for example \"*.h,*.c\").\n"
  "The patternname is optional.\n"
  "Some examples from my own setup of Adie (you can paste these from this help wind"
  "ow if you want) are shown below:\n"
  "\n"
  "  All Files (*)\n"
  "  All Source (*.cpp,*.cxx,*.cc,*.C,*.c,*.hpp,*.hxx,*.hh,*.H,*.h,*.y,*.l)\n"
  "  C++ Source Files (*.cpp,*.cxx,*.cc,*.c,*.C)\n"
  "  C++ Header Files (*.h,*.hpp,*.hxx,*.hh,*.H)\n"
  "  C Source Files (*.c)\n"
  "  C Header Files (*.h)\n"
  "  Python Files (*.py)\n"
  "  Perl Files (*.pl)\n"
  "  Ruby Files (*.rb)\n"
  "  Lex (*.l)\n"
  "  Yacc (*.y)\n"
  "  Object (*.o)\n"
  "  X Pixmap (*.xpm)\n"
  "  X Bitmap (*.xbm)\n"
  "\n"
  "Some details on the allowable wild-card patterns:\n"
  "\n"
  "  ?\tMatches single character.\n"
  "  *\tMatches zero or more characters.\n"
  "  [abc]\tMatches a single character, which must be a, b, or c.\n"
  "  [^abc]\tMatches a single character, which must be anything other than a, b, or"
  " c.\n"
  "  [!abc]\tDitto.\n"
  "  [a-zA-Z]\tMatches single character, which must be one of a-z or A-Z.\n"
  "  [^a-zA-Z]\tMatches single character, which must be anything other than a-z or "
  "A-Z.\n"
  "  [!a-zA-Z]\tDitto.\n"
  "  pat1|pat2\tMatches either pat1 or pat2.\n"
  "  pat1,pat2\tDitto.\n"
  "  (pat1|pat2)\tMatches either pat1 or pat2; patterns may be nested.\n"
  "  (pat1,pat2)\tDitto.\n"
  "\n"
  "\n"
  "Changing Delimiters.\n"
  "\n"
  "Different programming language have different notions about identifiers.  Adie a"
  "ccomodates for this by allowing you to specify which characters (besides white s"
  "pace, of course) are used to delimit identifiers or tokens in the programming la"
  "nguage. The default set of delimiters is \"!\"#$%&'()*+,-./:;<=>?@[\\]^`{|}~\".\n"
  "\n"
  "\n"
  "Syntax Coloring Text.\n"
  "\n"
  "Syntax highlighting colorizes source code based on recognizing certain patterns "
  "in the source files being edited.  For example, in C++ the keywords 'class' and "
  "'while' may be given a different color from normal text. When syntax highlightin"
  "g is enabled, the Adie editor will evaluate the color of each piece of text as y"
  "ou type it.  Thus, you'll have immediate feedback as misspellings of keywords wi"
  "ll be instantly obvious.\n"
  "Coloring the syntactical elements is only performed if syntax coloring is turned"
  " on, and a particular language syntax has been selected for the file.\n"
  "Colors may be assigned by the user using the 'Preferences' dialog, using the 'St"
  "yles' subpanel.  Each particular syntactical element may be given a different fo"
  "reground color and background color.  Separate colors are available for when a s"
  "yntactial element is highlighted, selected, or is the currently active cursor li"
  "ne.\n"
  "Apart from coloring, it is also possible to emphasize a syntactical element with"
  " underlines, strikeouts, or bold-face.  These effects may be selected by checkin"
  "g the underline, strikeout, or bold-face checkbuttons in the 'Styles' subpanel n"
  "ext to the style element.\n"
  "Colors that are set to fully transparent (alpha = 0), will revert to the default"
  " text foreground and background colors.  Most users will probably prefer not to "
  "set the background colors but only foreground colors, making it easier to keep b"
  "ackground colors consistent among the different syntactical elements.\n"
  "\n"
  "Language Matching.\n"
  "\n"
  "The set of patterns to be recognized in a piece of text are determined by the pr"
  "ogramming language syntax currently in effect for the text window.  The editor h"
  "as several ways to determine which language is to be used for colorizing the tex"
  "t:\n"
  "\n"
  "The first method is to look at the file's file-extension.  For example, a file e"
  "xtension '.py' will select the Python programming language. Each language syntax"
  " definition has a wildcard pattern which is matched against incoming filename, t"
  "o determine if that langauge should be used for colorizing the file.\n"
  "\n"
  "The second method is to look at a file's contents.  For example, when the string"
  " '#!/bin/bash' is spotted at the top of a file, the 'Shell' language is automati"
  "cally selected.  This is a very useful method since shell scripts very often don"
  "'t have a particular file extension.\n"
  "\n"
  "The third method is to scan the top or bottom of the file for a so-called 'model"
  "ine'.  Adie currently supports vi, emacs, and its own modeline syntax.  The mode"
  "line is typically embedded in a comment-section at the top or at the end of the "
  "source text, and may contain other specifications like tab settings and other hi"
  "nts for editing.\n"
  "\n"
  "The final method is for the user to simply enforce the programming language synt"
  "ax, by selecting the proper language syntax from the menu. Adie will write this "
  "association to the registry, so when the same file will get loaded in the future"
  ", the same language will be automatically selected. If this method is used, the "
  "entire filename is used as the key to determine the language syntax, and this wi"
  "ll be remembered in the registry setting from them on.\n"
  "You can remove this association by explicitly selecting the \"Plain\" language m"
  "ode while editing the file.\n"
  "\n"
  "\n"
  "Writing Custom Syntax Files.\n"
  "\n"
  "The syntax highlighting patterns in Adie are fully extensible, simply by writing"
  " you own language specification, or modifying one of the existing language speci"
  "fications in the 'Adie.stx' file delivered with the software.\n"
  "In order to get started on writing custom syntax patterns, it will be necessary "
  "to develop a basic understanding of how the syntax highlighting in Adie actually"
  " works.\n"
  "Consider the following simple language definition (this is actually the language"
  " definition of the language specification file itself!):\n"
  "\n"
  "  # Adie editor syntax-file syntax coloring\n"
  "  language \"Adie Syntax\"\n"
  "    filesmatch \"*.stx\"\n"
  "    contextlines 1\n"
  "    rule \"Comment\"\n"
  "      openpattern     \"#\"\n"
  "      closepattern    \"$\"\n"
  "      style           \"darkgreen\"\n"
  "    end\n"
  "    rule \"Keyword\"\n"
  "      pattern         \"\\<(language|filesmatch|contentsmatch|delimiters|context"
  "lines|contextchars|rule|group|end|pattern|openpattern|closepattern|stoppattern|s"
  "tyle|autoindent|wrapwidth|tabwidth|wordwrap|expandtabs)\\>\"\n"
  "      style           \"red\"\n"
  "    end\n"
  "    rule \"String\"\n"
  "      openpattern     \"\\\"\"\n"
  "      closepattern    \"\\\"\"\n"
  "      stoppattern     \"$\"\n"
  "      style           \"blue\"\n"
  "      rule \"Escape\"\n"
  "        pattern       \"\\\\\\\"\"\n"
  "        style         \"red\"\n"
  "      end\n"
  "    end\n"
  "  end\n"
  "\n"
  "The first line of this language specification is a comment line.  Comment lines "
  "start with '#' and extend to the end of the line.  You can place comments anywhe"
  "re on a line, but all text after the '#' becomes part of the comment up to the e"
  "nd of the line. The section between 'language' and 'end' is the actual language "
  "specification.  Each language specification must have a unique name, to distingu"
  "ish it from other language specifications.  A language specification contains a "
  "number of language-specific parameters, followed by a number of syntax rules.\n"
  "\n"
  "The first 'filesmatch' statement specifies the wildcard expressions that the fil"
  "ename should be matched against to identify this language as the one to be used "
  "for syntax coloring this file.  In this case, any file ending in '.stx' will use"
  " this language syntax.\n"
  "\n"
  "The statement 'contextlines' specifies how many lines to go backward and forward"
  " relative to a change in the text, in order to pick up an incremental recoloring"
  " of the text after a modification.  The larger this number is, the more time it "
  "takes to recolor. If developing a completely new language specification, its sug"
  "gested to leave this set as 1 and increase it until there are no more errors rec"
  "olorizing large documents.\n"
  "\n"
  "The syntax rules specify what patterns are matched and how to highlight/color th"
  "em. As can be seen from the language specification above, syntax rules may conta"
  "in other subrules.  This works as you expect: the nested rules colorize fragment"
  "s of text found within the outer rules.\n"
  "Each rule must have a name.  Rule names are used to assign colors, and so its OK"
  " to have different rules be given the same name, if they're to have the same col"
  "or.\n"
  "\n"
  "There are five types of rules:\n"
  "\n"
  " 1. Simple rule. Simple rules match only a single regular expression 'pattern'.\n"
  " 2. Bracket rule. Bracket rules match an 'openpattern' and 'closepattern'.\n"
  " 3. Safe bracket rule. A bracket rule with an additional 'stoppattern'.\n"
  " 4. Span rule. Match subrules inside a single over-arching pattern.\n"
  " 5. Default rule. A rule that matches all text and has no patterns.\n"
  "\n"
  "Except for the simple rule, the other rules may have subrules to colorize specif"
  "ic areas within the scope of that rule.  For example, inside the rule \"String\""
  " above, which colors text blue, rule \"Escape\" matches escape sequences and col"
  "ors them red. [An important detail is that the subrule patterns are matched befo"
  "re the closing rule of the outer rule, thus an escape like '\\\"' will prevent t"
  "he outer rule from seeing the '\"' as the end of the string.\n"
  "\n"
  "Within each rule, the optional 'style' keyword can be used to specify an initial"
  " color to be used for the text highlighted by that rule.\n"
  "\n"
  "The full list of keywords in the language specification is below:\n"
  "\n"
  "language \"name\" ... end\n"
  "\n"
  "The block between 'language' and 'end' describes one particular progamming langu"
  "age syntax.  Names must be unique.\n"
  "\n"
  "filesmatch \"wildcard\"\n"
  "\n"
  "This describes the wildcard pattern (see file patterns) used to matched against "
  "filenames or file extensions.  If there's a match, the language syntax will be u"
  "sed to higlight the file.\n"
  "\n"
  "contentsmatch \"regular-expression\"\n"
  "\n"
  "This sets the regular expression (see regular expressions) used to search the co"
  "ntents of the a small fragment of the file.  If the pattern is found, the langua"
  "ge syntax fill be used to highlight the file.\n"
  "\n"
  "delimiters \"string\"\n"
  "\n"
  "Sets the delimiters and punctuation characters considered to be not part of a wo"
  "rd in the language.  This affects next word, previous word cursor navigation com"
  "mands.\n"
  "\n"
  "contextlines <number>\n"
  "\n"
  "Sets the number of lines to search around after a change in text to pick up incr"
  "emental highlighting.  Set to 1 for many programming language but could be set b"
  "ased on largest syntactical element likely to be encountered.\n"
  "\n"
  "contextchars <number>\n"
  "\n"
  "Set the number of characters to search around after a change in text. Similar to"
  " 'contextlines' above.\n"
  "\n"
  "autoindent yes | no\n"
  "\n"
  "Set the auto indent feature for the language.  If set, the next new line after t"
  "he current line will be indented at the same level as the current line by insert"
  "ing spaces or tabs.  If no autoindent value is specified in the syntax descripti"
  "on, the default value will be in effect.\n"
  "\n"
  "wrapwidth <number>\n"
  "\n"
  "Set the number of columns to wrap text at, if text is to be wrapped.  The specia"
  "l value 0 wraps the text at the window-edge.  If no value is specified, the defa"
  "ult value will be in effect for this language.\n"
  "\n"
  "tabwidth <number>\n"
  "\n"
  "Set the number of columns a tab character indents with.  Typical value is 8.  If"
  " no value is specified, the default value will be in effect for this language.\n"
  "\n"
  "wordwrap yes | no\n"
  "\n"
  "Enables wrapping of long lines.  Lines will be broken at whitespace, if possible"
  ", to keep within the number of columns specified by 'wrapwidth' parameter, or th"
  "e window edge if 'wrapwidth' was set to 0.  If no value is specified, the defaul"
  "t value will be in effect for this language.\n"
  "\n"
  "expandtabs yes | no\n"
  "\n"
  "Enables tab expansion into spaces.  The number of spaces tabs expand into is set"
  " with 'tabwidth' parameter.  If no value is specified, the default value will be"
  " in effect for this language.\n"
  "\n"
  "group \"groupname\"\n"
  "\n"
  "Specifies this language is part of language group \"groupname\".  If specified, "
  "the language color scheme is consolidated on a per-group, rather than a per-lang"
  "uage basis.  For example, group \"C-Like\" comprises various programming languag"
  "es with similar syntactical elements.  Settings of a color scheme for one langua"
  "ge will then be applied to all languages in the group.  For this to work, rule n"
  "ames must match; rule \"Comment\" in the Java language specification will have t"
  "he same coloring as rule \"Comment\" in C or C++ language specification.  This c"
  "an be a real time-saver as it allows you to set colors for many languages\n"
  "in a consistent and succinct manner.\n"
  "\n"
  "rule \"name\" ... end\n"
  "\n"
  "Specifies a new language rule.  Within a rule, the following keywords may be use"
  "d.\n"
  "\n"
  "style \"colorname\"\n"
  "\n"
  "This will give text colored by the rule a color, unless specified from the regis"
  "try.  It is chiefly to ensure some highlighting is performed prior to customizin"
  "g the color scheme.\n"
  "Colors can be specified by name, for example \"Aquamarine\", or as a number hexa"
  "decimal digits, like #FF0000 (which yields a pure red).\n"
  "\n"
  "pattern \"regular-expression\"\n"
  "\n"
  "This sets the pattern this rule is to match against the text.  All text captured"
  " by the match will be colored by the colors associated with rule name. If quotes"
  " ('\"') are to be matched, make sure to escape them as '\\\"'. Only quotes ('\"'"
  ") need to be escaped for the syntax parser itself.\n"
  "\n"
  "openpattern \"regular-expression\"\n"
  "closepattern \"regular-expression\"\n"
  "stoppattern \"regular-expression\"\n"
  "\n"
  "This sets regular expression patterns for bracket and safe-bracket rules. A brac"
  "ket rule matches text against the regular expression specified by 'openpattern' "
  "and then colors all text subsequently until the place where the regular expressi"
  "on specified by 'closepattern' is found.  If 'stoppattern' is specified and enco"
  "untered before the close pattern, the rule breaks out early.  This is handy for "
  "rules which may match huge quantities of text while the user hasn't finished typ"
  "ing, for example open-ended strings or multi-line comments.\n"
  "Note that subrules, if any, are matched first before attempting close pattern or"
  " stop pattern.\n"
  "\n"
  "\n"
  "Finding the Syntax File.\n"
  "\n"
  "When Adie starts up, it normally looks in the directories listed in the PATH env"
  "ironment variable.  There are installations where this is not convenient.  There"
  "fore, it is possible to set the search directories using the special 'syntaxpath"
  "' registry setting.\n"
  "For testing purposes, you can also pass the filename of the syntax file directly"
  " on the command line using '-S' or '--syntax' flag.\n"
  "\n"
  "\n"
  "Other Configuration Issues.\n"
  "\n"
  "Because Adie is an editor written to use the FOX Toolkit, there are various othe"
  "r items, common to all FOX Toolkit programs, which may be configured either by h"
  "and or using some other control panel.\n"
  "A few items of particular interest are list below:\n"
  "\n"
  "  [SETTINGS]\n"
  "  typingspeed=800\n"
  "  clickspeed=400000000\n"
  "  scrollspeed=80000000\n"
  "  scrolldelay=600000000\n"
  "  blinkspeed=500000000\n"
  "  animspeed=20000000\n"
  "  menupause=400000000\n"
  "  tippause=800000000\n"
  "  tiptime=2000000000\n"
  "  dragdelta=6\n"
  "  wheellines=10\n"
  "  bordercolor=black\n"
  "  basecolor=AntiqueWhite3\n"
  "  hilitecolor=AntiqueWhite\n"
  "  shadowcolor=AntiqueWhite4\n"
  "  backcolor=AntiqueWhite1\n"
  "  forecolor=black\n"
  "  selforecolor=AntiqueWhite\n"
  "  selbackcolor=#aea395\n"
  "  tipforecolor=yellow\n"
  "  tipbackcolor=black\n"
  "  normalfont=\"[lucidatypewriter] 90 700 1 1 0 1\"\n"
  "  iconpath = /usr/share/icons:/home/jeroen/icons\n"
  "\n"
  "These settings can be either placed in $HOME/.foxrc (and thus affect all FOX pro"
  "grams), or in $HOME/.foxrc/FoxTest/Adie (only applying to Adie).\n"
  "File types may be bound to a command, mime-type, and icons using statements like"
  " the one below:\n"
  "\n"
  "  [FILETYPES]\n"
  "  cpp = \"/usr/local/bin/adie %s &;C++ Source File;c_src.xpm;mini/c_src.xpm\"\n"
  "  /home/jeroen = \";Home Directory;home.xpm;mini/home.xpm;application/x-folder\""
  "\n"
  "  defaultfilebinding = \"/usr/local/bin/adie %s &;Document;document.xpm;mini/doc"
  "ument.xpm\"\n"
  "  defaultexecbinding = \";Application;exec.xpm;mini/exec.xpm;application/x-execu"
  "table-file\"\n"
  "  defaultdirbinding = \";Folder;folder.xpm;mini/folder.xpm;application/x-folder\""
  "\n"
  "\n"
  "This example shows how the extension \".cpp\" is bound to the program \"adie\" a"
  "nd is associated with two icons, a big icon \"c_src.xpm\" and a small icon \"min"
  "i/c_src.xpm\", which are to be found in the directories determined by 'iconpath\""
  ", in this case, \"/usr/share/icons\" or \"/home/jeroen/icons\".\n"
  "\n"
  "It also binds two icons \"home.xpm\" and \"mini/home.xpm\" to the home directory"
  " \"/home/jeroen\".\n"
  "\n"
  "Finally, it assigns icons, commands, and mime-types to unbound documents, execut"
  "ables, and directories, overriding the built-in icons of the FOX Toolkit.\n"
  ""
  ;

